//
//	TypeListView.cpp
//


#include <stdio.h>
#include <string.h>
#include "APPI_Plugin.h"
#include "TypeListView.h"


TypeListView::TypeListView(BRect frame)
	: BListView(frame, "type list view", B_FOLLOW_ALL)
{
	SetSelectionMessage( new BMessage(msg_TypeSelected) );
}


TypeListView::~TypeListView()
{
}


void
TypeListView::DrawItem(BRect updateRect, long index)
{
	char	str[5], line[64];
	ulong	type = (ulong) ItemAt(index);
	BRect	area = ItemFrame(index);
	
	strncpy(str, (char*) &type, 4);
	str[4] = 0;

	sprintf(line, "%s (0x%x)", str, type);
	
	BPoint	drawloc(area.left + 4.0, area.bottom - BaselineOffset());
	DrawString(line, drawloc);	
}
